<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-project-innovation-initiative
* @subpackage controllers
* @filesource
*/ /** */

require_once APPPATH.'controllers/inbox.php';

/**
* @package direct-project-innovation-initiative
* @subpackage controllers
*/
class Message_controller extends Inbox {

	/**
	* Autosaves drafts.
	*
	* Drafts are populated via POST in the compose action; files to attach will be in the attachment cache.
	* After saving the draft, this method will populate the draft id in the session so that the 
	* save/send actions know to edit/send the existing draft instead of creating a new one.
	*
	* If the message does not have any values yet, autosave should NOT save the empty draft - we don't
	* want to overwhelm the drafts folder with empty drafts.
	*/
    public function ajax_draft_save() {
		//don't count this as activity
		$this->session->set_userdata('app_last_activity',$this->session->userdata('prev_last_activity'));
		
		//assuming the form submit went through the CSRF protection in order to get to this point,
		//give the new CSRF token as JSON output so the javascript can update it on the page
		$response = array('token'=>$this->security->get_csrf_hash(), 'total_size_of_attachments' => $this->user->attachment_cache_size_in_bytes());
		
		$message = $this->_message_from_post();
		
		//check to see if the message has been started yet - we don't want to autosave drafts that have no values
		$message_is_empty = (!isset($message->id) && empty($response['total_size_of_attachments']) && $message->importance == 'normal');
		foreach( array('subject', 'to', 'cc', 'bcc', 'body') as $field){
			if(!$message_is_empty) break; //something is populated, we can stop checking now
			$message_is_empty = ($message_is_empty && $message->property_is_empty($field));
		}
		
		if($message_is_empty){  //since message hasn't been populated yet, return true without any further action so the drafts folder isn't overwhelmed with empty drafts
			$response['success'] = true;
			echo json_encode($response);
			return true;
		}		
		
		if($response['total_size_of_attachments'] > MAX_ATTACHMENTS_SIZE*(1048576)){
			$response['error'] = 'The attachments for this message exceed the current size limit of '.byte_format(DIRECT_ATTACHMENT_SIZE_LIMIT).'.  Please remove one or more attachments.';
			$response['success'] = false;
			echo json_encode($response);
			return false;			
		}
		
		//make sure we have a message
		if(!Message::is_an_entity($message)){
			$response['error'] = 'Failed to find or create message object from POST';
			$response['success'] = false;
			echo json_encode($response);
			return false;
		}
	
		//save the message
		if(!$message->save( $preserve_existing_attachments = FALSE )){
			$response['error'] = 'Failed to save '.$message->describe().' from POST';
			$response['success'] = false;
			echo json_encode($response);
			return false;
		}
		
		//saving clears the cache, so make sure that the existing attachments are added to the cache
		$message->add_existing_attachments_to_cache();
		
		//if this is a reply/reply all/forward, set the flag on the parent message
		//we need to do this on autosave - otherwise, if a person exits out without saving and then re-opens the draft, we won't know what the parent id was and the parent message won't get flagged
		if(!empty($this->input->post('flag_value')) && Message::formatted_like_an_id($this->input->post('parent_message_id'))){
			$this->post_email_flag($this->input->post('parent_message_id',TRUE), $this->input->post('flag_value',TRUE), $this->mailbox->name);
		}
		
		$response['success'] = true;
		$response['id'] = $message->id;
		echo json_encode($response);
	}
		
		
	
    /* This function loads a view to display a single message with the given id.
     */
    public function viewmsg($id) {
		$data['connected'] = TRUE;
		if(!Message::formatted_like_an_id($id)) { show_404(); }
		
		//get the message with the provided id
		$folder = isset($_SESSION['folder']) ? strtolower($_SESSION['folder']) : 'inbox';
		$message = Message::find_one(array('folder' => $folder, 'id' => $id, 'mark' => 'read'));	
		$this->show_error_if_not_a_message($message);
		if($message->draft) redirect('inbox/compose/draft/' . $message->id);
		
		$data['title'] =  PORTAL_TITLE_PREFIX . $message->subject_for_display;
		$data['message'] = $message;
		$data['mailbox'] = $this->mailbox;
		$data['user'] = $this->user;
		$data['c32data'] = element('c32data', $this->mailformat->format_msg_display($message));
		
		//refresh mailbox list
		$data['mailboxes'] =  $this->mailformat->mailbox_list();

		//set message status
		$data['status_enabled'] = false;
#		if(isset($_SESSION['folder'])) { //this code doesn't appear to be folder related, so why are we making sure it's set first?  
		if($this->mailbox->is_group()) {
			$data['status_enabled'] = TRUE;
			
			$group_members = $this->get_group_members($this->mailbox->name);
			$data['group_members'] = array_combine(collect('id', $group_members), collect('name', $group_members));
			
			//get workflow data
			$this->load->model('workflow_model');
			if(isset($this->workflow_model)){
				$workflow_item = $this->workflow_model->find_for_message($message);
				if(!empty($workflow_item)){
					$data['workflow_item'] = $workflow_item;
				}
			}
						
		}
		//get attachement status and load das_results_model
		$this->load->model('das_results_model');
			
#		}		
		$this->template->set($data);
		$this->template->set('page_title', 'Message');
		$this->template->set('form_destination', 'inbox/archive/'.$id);
		$this->template->set('menu_partial', 'inbox/_view_menu');
		$this->template->load('inbox/template', 'inbox/view', $data);
		
		//pass data to the view and load it, or redirect to compose if its a draft
#		$this->load->view('inbox/view',$data);
    }	
	
/////////////////////
// PROTECTED METHODS
/////////////////////	
	

	
}
/* End of file inbox.php */
/* Location: ./application/controllers/inbox.php */